/*
 *  							PS/2 Keyer
 *
 *  Copyright (C) 2009  David Bern, W2LNX     W2LNX@ARRL.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 *  USA, or see <http://www.gnu.org/licenses/>.
 */

/* -------------------------------------------------------------------------- */

#define assert		/* needed for <assert.h> */

/* -------------------------------------------------------------------------- */

#define PROJECT "PS/2 Keyer"

		/* configure here */

#define DEBUG 	0
#define TESTING 0

#define PS2_KEYER_KEYBOARD	1
#define PS2_KEYER_MOUSE		1

/* -------------------------------------------------------------------------- */

#define MARK_PIN	PIN_A5
#define STATUS_LED	PIN_A6		/* change here as necessary */
#define ERROR_LED	STATUS_LED

/* -------------------------------------------------------------------------- */

		/* interrupt configuration */

#define INTERRUPTS_ENABLED	TRUE

#define INT_EXT_ENABLED		FALSE
#define INT_EXT1_ENABLED	FALSE
#define INT_EXT2_ENABLED	FALSE
#define INT_RB_ENABLED		TRUE
#define INT_TIMER1_ENABLED	FALSE
#define INT_TIMER3_ENABLED	TRUE

/* -------------------------------------------------------------------------- */

		/* PS/2 port definitions */

			/* connected to host ports */

				/* port 0: connected to keyboard host port 
					-- act as keyboard device */

#define CLOCK0_PIN			PIN_B0		/* can generate an INT0 interrupt */
#define DATA0_PIN			PIN_B1		/* can generate an INT1 interrupt */
#define CLOCK0_BIT			0
#define DATA0_BIT			1
#define PORT0_LED			PIN_A0

#define keyboard_host_clock		CLOCK0_PIN	
#define keyboard_host_data		DATA0_PIN
#define keyboard_host_led		PORT0_LED


				/* port 1: connected to mouse host port 
					-- act as mouse device */

#define CLOCK1_PIN			PIN_B2		/* can generate an INT2 interrupt */
#define DATA1_PIN			PIN_B3
#define CLOCK1_BIT			2
#define DATA1_BIT			3
#define PORT1_LED			PIN_A1

#define mouse_host_clock 		CLOCK1_PIN
#define mouse_host_data 		DATA1_PIN
#define mouse_host_led			PORT1_LED


			/* connected to devices */

				/* port 2: connected to keyboard device 
					-- act as keyboard host */

#define CLOCK2_PIN			PIN_B4		/* can generate an INT_RB interrupt */
#define DATA2_PIN			PIN_B5		/* can generate an INT_RB interrupt */
#define CLOCK2_BIT			4
#define DATA2_BIT			5
#define PORT2_LED			PIN_A2

#define	keyboard_device_clock 	CLOCK2_PIN	
#define	keyboard_device_data  	DATA2_PIN
#define	keyboard_device_led		PORT2_LED

				/* also connected to CW paddle */

#define paddle_left_contact			CLOCK2_PIN
#define paddle_right_contact		DATA2_PIN
#define paddle_left_contact_bit		CLOCK2_BIT
#define paddle_right_contact_bit	DATA2_BIT

#define paddle_dit_contact			paddle_left_contact
#define paddle_dah_contact			paddle_right_contact
#define paddle_dit_contact_bit		paddle_left_contact_bit
#define paddle_dah_contact_bit		paddle_right_contact_bit


				/* port 3: connected to mouse device 
					-- act as mouse host */

#define CLOCK3_PIN			PIN_B6		/* can generate an INT_RB interrupt */
#define DATA3_PIN			PIN_B7		/* can generate an INT_RB interrupt */
#define CLOCK3_BIT			6
#define DATA3_BIT			7
#define PORT3_LED			PIN_A3

#define	mouse_device_clock		CLOCK3_PIN	
#define	mouse_device_data		DATA3_PIN 
#define	mouse_device_led		PORT3_LED

/* -------------------------------------------------------------------------- */

